/*
 * Decompiled with CFR 0.152.
 */
package com.dinzeer.legendblade;

import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class Util {
    public static double sin(double angle) {
        return Math.sin(angle / 180.0 * Math.PI);
    }

    public static double cos(double angle) {
        return Math.cos(angle / 180.0 * Math.PI);
    }

    public static double tan(double angle) {
        if (angle == 90.0) {
            throw new IllegalArgumentException("tan 90 is invalid!");
        }
        return Math.tan(angle / 180.0 * Math.PI);
    }

    public static double arcsin(double value) {
        if (value > 1.0) {
            throw new IllegalArgumentException("arcsin value > 1, which is invalid!");
        }
        if (value < -1.0) {
            throw new IllegalArgumentException("arcsin value < -1, which is invalid!");
        }
        return Math.asin(value) / Math.PI * 180.0;
    }

    public static double arccos(double value) {
        if (value > 1.0) {
            throw new IllegalArgumentException("arccos value > 1, which is invalid!");
        }
        if (value < -1.0) {
            throw new IllegalArgumentException("arccos value < -1, which is invalid!");
        }
        return Math.acos(value) / Math.PI * 180.0;
    }

    public static double arctan(double value) {
        return Math.atan(value) / Math.PI * 180.0;
    }

    public static double getRtTriangleH(double H, double L) {
        return Math.sqrt(L * L - H * H);
    }

    public static double pow2(double x) {
        return Math.pow(x, 2.0);
    }

    public static int sign(double a) {
        return (int)Math.round(Math.abs(a) / a);
    }

    public static int sign(float a) {
        return Math.round(Math.abs(a) / a);
    }

    public static int sign(int a) {
        return Math.round(Math.abs(a) / a);
    }

    public static double distanceXOY(Vec2 v1, Vec2 v2) {
        return Math.sqrt(Math.pow(v1.f_82470_ - v2.f_82470_, 2.0) + Math.pow(v1.f_82471_ - v2.f_82471_, 2.0));
    }

    public static double distanceXOY(Vec3 v1, Vec3 v2) {
        return Math.sqrt(Math.pow(v1.f_82479_ - v2.f_82479_, 2.0) + Math.pow(v1.f_82480_ - v2.f_82480_, 2.0));
    }

    public static double distanceXYZ(Vec3 v1, Vec3 v2) {
        return Math.sqrt(Math.pow(v1.f_82479_ - v2.f_82479_, 2.0) + Math.pow(v1.f_82480_ - v2.f_82480_, 2.0) + Math.pow(v1.f_82481_ - v2.f_82481_, 2.0));
    }

    public static double clip(double input, double max, double min) {
        return Math.min(Math.max(input, min), max);
    }

    public static int clip(int input, int max, int min) {
        return Math.min(Math.max(input, min), max);
    }

    public static float clip(float input, float max, float min) {
        return Math.min(Math.max(input, min), max);
    }

    public static Vec3 xozVec2ToVec3(Vec2 v, double y) {
        return new Vec3((double)v.f_82470_, y, (double)v.f_82471_);
    }

    public static Vec2 getClockwiseRotatedVec2(Vec2 referencePos, Vec2 pos, double rotatedAngle) {
        Vec3 vr = Util.xozVec2ToVec3(referencePos, 0.0);
        Vec3 vp = Util.xozVec2ToVec3(pos, 0.0);
        Vec3 initRay = vp.m_82546_(vr).m_82541_();
        double r = vp.m_82546_(vr).m_82553_();
        double initAngle = Util.arccos(initRay.f_82481_) * initRay.f_82479_ / Math.abs(initRay.f_82479_);
        double retX = Util.sin(initAngle + rotatedAngle) * r + vr.f_82479_;
        double retY = Util.cos(initAngle + rotatedAngle) * r + vr.f_82481_;
        return new Vec2((float)retX, (float)retY);
    }

    public static Vec3 round(Vec3 v, int digit) {
        double scale = Math.pow(10.0, digit);
        double x = (double)Math.round(v.f_82479_ * scale) / scale;
        double y = (double)Math.round(v.f_82480_ * scale) / scale;
        double z = (double)Math.round(v.f_82481_ * scale) / scale;
        return new Vec3(x, y, z);
    }

    public static Vec2 round(Vec2 v, int digit) {
        double scale = Math.pow(10.0, digit);
        double x = (double)Math.round((double)v.f_82470_ * scale) / scale;
        double y = (double)Math.round((double)v.f_82471_ * scale) / scale;
        return new Vec2((float)x, (float)y);
    }
}

